function GetAngleFacingClaw(self)
	local claw = GetClaw()
	return math.deg(math.atan2(claw.Y-self.Y,claw.X-self.X))
end

function GetAngleFacingTarget(self, x, y)
	return math.deg(math.atan2(y-self.Y,x-self.X))
end

function GetDistanceTo(self, x, y)
	return math.sqrt((y-self.Y)^2+(x-self.X)^2)
end

function main(self)
	if self.State == 0 then
		self.WeaponTimer = GetTime()
		self.MoveTimer = GetTime()
		self.DurationTimer = GetTime()
		self.Attempt = Attempt()
		self.Duration = self.Speed
		self.AttackCount = 1
		
		self.BossStager = GetObject(4098)
		self.AretiObject = self.BossStager.Areti
		self.StartStage = self.AretiObject.stage
		self.DanmakuType = self.Smarts
		self.DrawFlags.NoDraw = true
		self.targetX = self.X
		self.targetY = self.Y
		self.State = 1
	elseif self.State == 1 then
		local claw = GetClaw()
		self.targetX = claw.X
		self.targetY = claw.Y
		self.State = 2
	elseif self.State == 2 then
		if GetTime() > self.MoveTimer + 250 then
			self.Angle = math.rad(GetAngleFacingTarget(self, self.targetX, self.targetY))
			if GetDistanceTo(self, self.targetX, self.targetY) <= 64 then
				self.X = self.targetX
				self.Y = self.targetY
				self.WeaponTimer = GetTime()
				self.AttackCount = 1
				self.State = 3
			else
				self.X = self.X + math.cos(self.Angle)*48
				self.Y = self.Y + math.sin(self.Angle)*48
			end
			self.MoveTimer = GetTime()
			CreateObject {x=self.X, y=self.Y, z=9000, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLEREDBIG"}
		end
	elseif self.State == 3 then
		if self.AttackCount < 12 then
			if GetTime() > self.WeaponTimer + 100 then
				bX = self.X + math.cos(math.rad(self.AttackCount*30))*36
				bY = self.Y + math.sin(math.rad(self.AttackCount*30))*36
				local b = CreateObject {x=bX, y=bY, z=7014, I=1, name="DelayedBullet", logic="CustomLogic", image="CUSTOM_ELDRITCHWARP", Damage = 0, Counter = 0, Smarts = 8, Health = 0, SpeedX = self.X, SpeedY = self.Y}
				b.Flags.AlwaysActive = true
				self.WeaponTimer = GetTime()
				self.AttackCount = self.AttackCount + 1
			end
		else
			self.State = 1
		end
		
		
		--local b = CreateObject {x=self.X, y=self.Y, z=7014, I=v["i"], name="DelayedBullet", logic="CustomLogic", image="CUSTOM_ELDRITCHWARP", Damage = 0, Counter = 0, Smarts = 8, Health = 0, SpeedX = self.X, SpeedY = self.Y}
		--b.Flags.AlwaysActive = true
	end
		if false and GetTime() > self.WeaponTimer + 1200 then
			if self.DanmakuType == 1 then
				baseangle = GetAngleFacingClaw(self)
				angle = 30
				for j=baseangle,baseangle+(360-angle),angle do
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j, Smarts = 1, Health = 0}
					b.Flags.AlwaysActive = true
				end
			elseif self.DanmakuType == 2 then
				baseangle = GetAngleFacingClaw(self)
				angle = 30
				for j=baseangle+15,baseangle+15+(360-angle),angle do
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=3, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j, Smarts = 1, Health = 0}
					b.Flags.AlwaysActive = true
				end
			end
			self.WeaponTimer = GetTime()
		end
		if self.Attempt < Attempt() then
			self:Destroy()
		end
		if self.AretiObject.stage > self.StartStage then
			self:Destroy()
		end
		if GetTime() >= self.DurationTimer + self.Duration then
			self:Destroy()
		end
	
end